Text = copy_table(Shape)

---[[
Text.sample_definition = {
    type = "Text",
    font = "hud18",
    align = "left",
    x = 200, y = 200, z = 1000,
    w = 300,
    h = 100,
    text = "Lorem ipsum dolor",
    color = "FF8888",
    alpha = 0.5,
}
--]]

function Text:init(def, view)
    Shape.init(self, def, view)
    
    self.font = def.font
    self.align = def.align
    self.text = def.text or ""
    self.alpha = def.alpha or 1
    self.color = def.color
end


function Text:set_text(text)
    self.text = text
end


function Text:render()
    gfx_render_text(self.font, self.x, self.y, self.text, self.align, self.w, self.h, self.alpha, self.color)
end
